package ru.yandex.calendar.frontend.api.todo;

import ru.yandex.calendar.frontend.api.XmlOrJsonApiActionSupport;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.util.color.Color;
import ru.yandex.calendar.util.xmlorjson.XmlOrJsonWriter;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author gutman
 */
@WithMasterSlavePolicy(MasterSlavePolicy.R_MS)
public class GetTodoListColorsAction extends XmlOrJsonApiActionSupport {

    @Override
    protected XmlOrJsonWritable doExecute() {
        return new XmlOrJsonWritable() {
            public void write(XmlOrJsonWriter w) {
                w.startArray("colors");
                for (Color color : TodoUtils.TODO_LIST_COLORS) {
                    w.startObject("color");
                    w.addTextField("value", color.printRgb());
                    w.endObject();
                }
                w.endArray();
            }
        };
    }

}
