package ru.yandex.calendar.frontend.api.todo;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.beans.generated.TodoList;
import ru.yandex.calendar.logic.todo.TodoDao;
import ru.yandex.calendar.util.xmlorjson.XmlOrJsonWriter;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author gutman
 */
@WithMasterSlavePolicy(MasterSlavePolicy.R_MS)
public class GetTodoListsAction extends ApiTodoUserAction {

    @Autowired
    private TodoDao todoDao;

    @Override
    protected XmlOrJsonWritable doExecute() {
        Option<Long> defaultListId = findFirstUserCreatedTodoListOrCreateNewIfNotMaya();

        final ListF<TodoList> todoLists = todoDao.findNotDeletedUserTodoLists(getUid());

        MapF<Long, Long> counts = todoDao.findNotDeletedNotArchivedNotCompletedTodoItemsCountsByTodoListIds(
                todoLists.map(TodoList.getIdF())).toMap();

        final Function<Long, Long> todoItemsCount = id -> counts.getOrElse(id, 0L);

        return new XmlOrJsonWritable() {
            public void write(XmlOrJsonWriter w) {
                w.startArray("todo-lists");

                for (TodoList todoList : todoLists) {
                    w.startObject("todo-list");

                    TodoSerializer.serializeTodoListFields(w, todoList, defaultListId.isSome(todoList.getId()));
                    w.addTextField("todo-items-count", todoItemsCount.apply(todoList.getId()));

                    w.endObject();
                }
                w.endArray();
            }
        };
    }
}
