package ru.yandex.calendar.frontend.api.todo;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author gutman
 */
@WithMasterSlavePolicy(MasterSlavePolicy.R_SM)
public class GetTodoTimestampAction extends ApiTodoUserAction {

    @Autowired
    private TodoRoutines todoRoutines;

    @Override
    protected XmlOrJsonWritable doExecute() {
        return XmlOrJsonWritable.textField(
                "todo-timestamp", todoRoutines.getTodoLastUpdateTs(getUid()).getMillis() / 1000);
    }
}
