package ru.yandex.calendar.frontend.api.todo;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.beans.generated.UiSettings;
import ru.yandex.calendar.logic.user.UiSettingsDao;
import ru.yandex.calendar.util.xmlorjson.XmlOrJsonWriter;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author gutman
 */
@WithMasterSlavePolicy(MasterSlavePolicy.R_MS)
public class GetTodoWebSettingsAction extends ApiTodoUserAction {
    private static final Logger logger = LoggerFactory.getLogger(GetTodoWebSettingsAction.class);

    @Autowired
    private UiSettingsDao uiSettingsDao;

    @Override
    protected XmlOrJsonWritable doExecute() {
        final Option<UiSettings> uiSettings = uiSettingsDao.findUiSettingsByUid(getUid());

        return new XmlOrJsonWritable() {
            public void write(XmlOrJsonWriter w) {
                w.startObject("todo-web-settings");

                w.addTextField("uid", getUid().getUid());
                if (uiSettings.isPresent()) {
                    w.addTextField("settings", uiSettings.get().getTodoWebSettings());
                } else {
                    w.addTextField("settings", "");
                }
                w.endObject();
            }
        };
    }

}
