package ru.yandex.calendar.frontend.api.todo;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.a3.interceptors.ActionWithLockAndTransaction;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.frontend.api.ics.IcsApiManager;
import ru.yandex.calendar.frontend.api.ics.TodoImportResult;
import ru.yandex.calendar.logic.ics.IcsUtils;
import ru.yandex.calendar.logic.ics.imp.IcsTodoImporter;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.util.xmlorjson.XmlOrJsonWriter;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;

/**
 * @author gutman
 */
public class ImportCalendarWithTodosByIcsUrlAction extends ApiTodoUserAction implements ActionWithLockAndTransaction {

    @Autowired
    IcsTodoImporter icsTodoImporter;
    @Autowired
    private IcsApiManager icsApiManager;
    @Autowired
    private TodoRoutines todoRoutines;

    @RequestParam
    private String icsUrl;
    @RequestParam(required = false)
    private boolean deleteOldIfExists = false;

    @Override
    protected XmlOrJsonWritable doExecute() {
        byte[] calendarBytes = ApacheHttpClientUtils.download(UrlUtils.urlDecode(icsUrl));
        IcsCalendar calendar = IcsUtils.parseBytesInGuessedEncoding(calendarBytes);

        final TodoImportResult todoImportResult =
                icsApiManager.importCalendarWithTodos(calendar, getUid(), getActionInfo(), deleteOldIfExists);

        return new XmlOrJsonWritable() {
            public void write(XmlOrJsonWriter w) {
                if (todoImportResult.getListAlreadyExists()) {
                    w.addTextField("list-already-exists", "");
                } else if (todoImportResult.getImportedToNewList()) {
                    w.addTextField("new-todo-list-external-id", todoImportResult.getNewTodoListExternalId());
                } else if (todoImportResult.getListAlreadyExistsAndOverwritten()){
                    w.startObject("list-already-exists-and-overwritten");
                    w.addTextField("deleted-list-external-id", todoImportResult.getDeletedListExternalId());
                    w.endObject();
                } else {
                    w.addTextField("imported-to-default-list", "");
                }
            }
        };
    }
}
