package ru.yandex.calendar.frontend.api.todo;

/**
 * @author gutman
 */
public enum OutputMode {
    FULL("full"),
    MOBILE("mobile"),
    ;

    private final String value;

    OutputMode(String value) {
        this.value = value;
    }

    public static OutputMode byName(String name) {
        for (OutputMode mode : values()) {
            if (mode.value.equals(name)) {
                return mode;
            }
        }
        throw new IllegalArgumentException(name);
    }
}
