package ru.yandex.calendar.frontend.api.todo;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.a3.interceptors.ActionWithLockAndTransaction;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.logic.todo.id.TodoIdOrExternalId;
import ru.yandex.commune.a3.action.parameter.ValidateParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestListParam;

/**
 * @author dbrylev
 */
public class ReorderTodoItemsAction extends ApiActionWithIdOrExternalId implements ActionWithLockAndTransaction {

    @Autowired
    private TodoRoutines todoRoutines;

    @RequestListParam
    private ListF<Integer> positions = Cf.list();

    @Override
    protected XmlOrJsonWritable doExecute() {
        ListF<TodoIdOrExternalId> todoIds = getTodoIdOrExternalIds();

        ValidateParam.forAll("todoIds", todoIds, TodoIdOrExternalId::isId);
        ValidateParam.hasSize("positions", positions, todoIds.size());

        todoRoutines.reorder(getUid(), getListIdOrExternalId(),
                todoIds.map(TodoIdOrExternalId::getId).zip(positions), getActionInfo());

        return XmlOrJsonWritable.empty();
    }
}
