package ru.yandex.calendar.frontend.api.todo;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.a3.interceptors.ActionWithLockAndTransaction;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.todo.TodoRoutines;

/**
 * @author gutman
 */
public class RestoreTodoItemsAction extends ApiActionWithIdOrExternalId implements ActionWithLockAndTransaction {

    @Autowired
    private TodoRoutines todoRoutines;

    @Override
    protected XmlOrJsonWritable doExecute() {
        todoRoutines.restoreTodoItemsByIds(getUid(), getTodoIdOrExternalIds(), getActionInfo());

        return XmlOrJsonWritable.empty();
    }

}
