package ru.yandex.calendar.frontend.api.todo;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.a3.interceptors.ActionWithLockAndTransaction;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.todo.TodoRoutines;

/**
 * @author gutman
 */
public class RestoreTodoListAction extends ApiActionWithIdOrExternalId implements ActionWithLockAndTransaction {

    @Autowired
    private TodoRoutines todoRoutines;

    @Override
    protected XmlOrJsonWritable doExecute() {
        todoRoutines.restoreTodoListById(getUid(), getListIdOrExternalId(), getActionInfo());

        return XmlOrJsonWritable.textField("deleted-todo-list-id", getListIdOrExternalId().toIdOrExternalIdString());
    }

}
