package ru.yandex.calendar.frontend.api.todo;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.a3.interceptors.ActionWithLockAndTransaction;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;

/**
 * @author gutman
 */
public class SetTodoItemsCompletedAction extends ApiActionWithIdOrExternalId implements ActionWithLockAndTransaction {

    @Autowired
    private TodoRoutines todoRoutines;

    @RequestParam
    private boolean completed;

    @Override
    protected XmlOrJsonWritable doExecute() {
        // XXX may be not found
        todoRoutines.updateTodoItemsSetCompleted(getUid(), getTodoIdOrExternalIds(), completed, getActionInfo());

        return XmlOrJsonWritable.empty();
    }
}
