package ru.yandex.calendar.frontend.api.todo;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.a3.interceptors.ActionWithLockAndTransaction;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.beans.generated.UiSettings;
import ru.yandex.calendar.logic.user.UiSettingsDao;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author gutman
 */
public class SetTodoWebSettingsAction extends ApiTodoUserAction implements ActionWithLockAndTransaction {
    private static final Logger logger = LoggerFactory.getLogger(SetTodoWebSettingsAction.class);

    @Autowired
    private UiSettingsDao uiSettingsDao;

    @RequestParam
    private String settings;

    @Override
    protected XmlOrJsonWritable doExecute() {
        Option<UiSettings> uiSettingsO = uiSettingsDao.findUiSettingsByUid(getUid());
        if (uiSettingsO.isPresent()) {
            uiSettingsDao.updateTodoWebSettingsByUid(settings, getUid());
        } else {
            UiSettings uiSettings = new UiSettings();
            uiSettings.setUid(getUid());
            uiSettings.setTodoWebSettings(settings);
            uiSettingsDao.saveUiSettings(uiSettings);
        }
        return XmlOrJsonWritable.empty();
    }
}
