package ru.yandex.calendar.frontend.api.todo;

import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.util.dates.DateTimeFormatter;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.time.Iso8601;

/**
 * @author gutman
 * XXX: kill unixtime
 */
public class TodoTimeConverter {

    static boolean isAllDay(Option<String> unixtime, Option<String> dateTime) {
        return !unixtime.isPresent() && dateTime.isMatch(s -> !s.contains("T"));
    }

    static Option<Instant> convertOnCreate(Option<String> unixtime, Option<String> dateTime, DateTimeZone tz) {
        if (unixtime.isPresent()) {
            Validate.isFalse(dateTime.isPresent());

            long notificationTsMillis = Long.parseLong(unixtime.get()) * 1000;

            return Option.of(new Instant(notificationTsMillis));
        } else if (dateTime.isPresent()) {
            Validate.isFalse(unixtime.isPresent());

            Instant i = parseDateTime(dateTime.get(), tz);

            return Option.of(i);
        } else {
            return Option.empty();
        }
    }

    // XXX upyachka, kill unixtime and Option<Option>
    static Option<Option<Instant>> convertOnUpdate(Option<String> unixtime, Option<String> dateTime, DateTimeZone tz) {
        if (unixtime.isPresent()) {
            Validate.isFalse(dateTime.isPresent());

            if (unixtime.get().isEmpty()) {
                return Option.of(Option.<Instant>empty());
            }

            long notificationTsMillis = Long.parseLong(unixtime.get()) * 1000;

            return Option.of(Option.of(new Instant(notificationTsMillis)));
        } else if (dateTime.isPresent()) {
            Validate.isFalse(unixtime.isPresent());

            if (dateTime.get().isEmpty()) {
                return Option.of(Option.<Instant>empty());
            }

            Instant i = parseDateTime(dateTime.get(), tz);

            return Option.of(Option.of(i));
        } else {
            return Option.empty();
        }
    }

    static String printNotificationDateTime(Instant notificationTs, DateTimeZone tz) {
        return DateTimeFormatter.formatLocalDateTimeForMachines(new LocalDateTime(notificationTs, tz));
    }

    static String printNotificationDate(Instant notificationTs, DateTimeZone tz) {
        return DateTimeFormatter.formatLocalDateForMachines(new LocalDate(notificationTs, tz));
    }

    static Instant parseDateTime(String dateTime, DateTimeZone tz) {
        if (dateTime.contains("T")) {
            return Iso8601.parseLocalDateTime(dateTime).toDateTime(tz).toInstant();
        } else {
            return Iso8601.parseLocalDate(dateTime).toDateTimeAtStartOfDay(tz).toInstant();
        }
    }

}
