package ru.yandex.calendar.frontend.api.todo;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.calendar.util.color.Color;

/**
 * @author gutman
 */
public class TodoUtils {

    public static final ListF<Color> TODO_LIST_COLORS = Cf.list(
            Color.parseRgba("#B9B9B9FF"), Color.parseRgba("#EDAFC5FF"), Color.parseRgba("#FFC4C4FF"),
            Color.parseRgba("#FFCE94FF"), Color.parseRgba("#FFEA84FF"), Color.parseRgba("#B4DD99FF"),
            Color.parseRgba("#BBDACFFF"), Color.parseRgba("#C1D9FFFF"), Color.parseRgba("#EBB4FDFF"));

    private static final MapF<Language, String> localizedListNames = Cf.hashMap();

    static {
        // CAL-4780
        localizedListNames.put(Language.RUSSIAN, "Не забыть");
        localizedListNames.put(Language.TURKISH, "Hatırlatma");
        localizedListNames.put(Language.UKRAINIAN, "Не забути");
        localizedListNames.put(Language.TATAR, "Онытмау");
        localizedListNames.put(Language.AZERBAIJANI, "Unutmayın");
        localizedListNames.put(Language.ARMENIAN, "Չմոռանալ");
        localizedListNames.put(Language.GEORGIAN, "არ დამავიწყდეს");
        localizedListNames.put(Language.BELARUSIAN, "Не забыць");
        localizedListNames.put(Language.KAZAKH, "Ұмытпау");
        localizedListNames.put(Language.ROMANIAN, "De reţinut");
        localizedListNames.put(Language.ENGLISH, "Not to forget");
    }

    public static String getDefaultListName(Option<Language> language) {
        return language.isPresent()
                ? localizedListNames.getO(language.get()).getOrElse(TodoRoutines.DEFAULT_LIST_NAME)
                : TodoRoutines.DEFAULT_LIST_NAME;
    }

    public static String getDefaultItemName(Option<Language> language) {
        return getDefaultListName(language);
    }
}
