package ru.yandex.calendar.frontend.api.todo;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.a3.converters.ConverterToIntColor;
import ru.yandex.calendar.frontend.a3.interceptors.ActionWithLockAndTransaction;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.beans.generated.TodoList;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;

/**
 * @author gutman
 */
public class UpdateTodoListAction extends ApiActionWithIdOrExternalId implements ActionWithLockAndTransaction {

    @Autowired
    private TodoRoutines todoRoutines;

    @RequestParam
    private Option<String> title = Option.empty();
    @RequestParam
    private Option<String> description = Option.empty();
    @RequestParam(customConverter = ConverterToIntColor.class, ignoreEmpty = true)
    private Option<Integer> color = Option.empty();

    @Override
    protected XmlOrJsonWritable doExecute() {
        TodoList todoList = new TodoList();
        if (title.isPresent()) todoList.setTitle(title.get());
        if (description.isPresent()) todoList.setDescription(description.get());
        if (color.isPresent()) {
            if (color.get() == null) {
                todoList.setColorNull();
            } else {
                todoList.setColor(color.get());
            }
        }
        if (todoList.isEmpty()) return XmlOrJsonWritable.empty();

        todoRoutines.updateTodoListById(getUid(), todoList, getListIdOrExternalId(), getActionInfo());

        return XmlOrJsonWritable.empty();
    }
}
