package ru.yandex.calendar.frontend.api.webNew;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.calendar.boot.CalendarAppName;
import ru.yandex.calendar.frontend.a3.interceptors.CalendarRequestInterceptor;
import ru.yandex.calendar.frontend.a3.interceptors.CommandExecutionMonitoringInterceptor;
import ru.yandex.calendar.frontend.a3.interceptors.LogActionParametersInterceptor;
import ru.yandex.calendar.frontend.a3.redirect.RedirectContextA3Configuration;
import ru.yandex.calendar.frontend.webNew.WebNewContextConvertersConfiguration;
import ru.yandex.calendar.frontend.webNew.WebNewJsonResultSerializer;
import ru.yandex.calendar.frontend.webNew.actions.WebNewActionsContextConfiguration;
import ru.yandex.calendar.logic.domain.PassportAuthDomainsHolder;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.log.requests.RequestLoggingContextA3Configuration;
import ru.yandex.calendar.monitoring.WebApiMonitoringConfiguration;
import ru.yandex.calendar.tvm.TvmManager;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.action.A3DefaultContextConfiguration;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.ApplicationResultType;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.commune.a3.db.MasterSlavePolicyInterceptor;
import ru.yandex.misc.version.Version;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

@Configuration
@Import({
        A3DefaultContextConfiguration.class,
        WebNewContextConvertersConfiguration.class,
        WebNewActionsContextConfiguration.class,
        WebApiMonitoringConfiguration.class,
        RequestLoggingContextA3Configuration.class,
        RedirectContextA3Configuration.class,
})
public class ApiWebNewContextA3Configuration {

    @Autowired
    @Qualifier("apiJetty")
    private SingleWarJetty jetty;
    @Autowired
    private ActionApp actionApp;

    @PostConstruct
    public void configure() {
        jetty.addServletMapping("/internal/*", actionApp.createServlet());
    }

    @Bean
    public ApplicationInfo applicationInfo(CalendarAppName calendarAppName, Version version) {
        return new ApplicationInfo(calendarAppName.appName(), version.getProjectVersion());
    }

    @Bean
    public WebNewJsonResultSerializer webNewJsonResultSerializer() {
        return new WebNewJsonResultSerializer();
    }

    @Bean
    public ApplicationResultType applicationResultType() {
        return new ApplicationResultType(MediaType.APPLICATION_JSON);
    }

    @Bean
    public CalendarRequestInterceptor calendarRequestInterceptor(PassportAuthDomainsHolder domains, TvmManager tvmManager) {
        return new CalendarRequestInterceptor(ActionSource.INTERNAL_API, domains, tvmManager);
    }

    @Bean
    public MasterSlavePolicyInterceptor masterSlavePolicyInterceptor() {
        return new MasterSlavePolicyInterceptor();
    }

    @Bean
    public LogActionParametersInterceptor logActionParametersInterceptor() {
        return new LogActionParametersInterceptor();
    }

    @Bean
    public CommandExecutionMonitoringInterceptor commandExecutionMonitoringInterceptor() {
        return new CommandExecutionMonitoringInterceptor();
    }
}
