package ru.yandex.calendar.frontend.bender;

import ru.yandex.bolts.collection.Option;

/**
 * @author dbrylev
 */
public class Change<T> {
    private final T before;
    private final T after;

    public Change(T before, T after) {
        this.before = before;
        this.after = after;
    }

    public static <T> Change<T> change(T before, T after) {
        return new Change<>(before, after);
    }

    public static <T> Option<Change<T>> changeO(T before, T after) {
        return Option.when(!before.equals(after), new Change<>(before, after));
    }

    public T getBefore() {
        return before;
    }

    public T getAfter() {
        return after;
    }
}
