package ru.yandex.calendar.frontend.bender;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.NameWithNamespace;
import ru.yandex.misc.bender.PartPosition;
import ru.yandex.misc.bender.internal.pojo.PojoMarshaller;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.Marshaller;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshallerSupport;

/**
 * @author dbrylev
 */
public class ChangeMarshaller extends ToFieldMarshallerSupport {

    private final Marshaller valueMarshaller;

    public ChangeMarshaller(Marshaller valueMarshaller) {
        this.valueMarshaller = valueMarshaller;
    }

    @Override
    public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
        Change change = (Change) fieldValue;

        writer.writeObjectStart();

        PojoMarshaller.writeJsonOneField(writer, valueMarshaller, change.getBefore(),
                PartPosition.ordinary(NameWithNamespace.normalized("before", Option.empty())), context);
        PojoMarshaller.writeJsonOneField(writer, valueMarshaller, change.getAfter(),
                PartPosition.ordinary(NameWithNamespace.normalized("after", Option.empty())), context);

        writer.writeObjectEnd();
    }
}
