package ru.yandex.calendar.frontend.bender;

import org.apache.commons.lang.NotImplementedException;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.config.BenderSettings;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactory;
import ru.yandex.misc.bender.parse.MainUnmarshallerFactory;
import ru.yandex.misc.bender.parse.Unmarshaller;
import ru.yandex.misc.bender.serialize.MainMarshallerFactory;
import ru.yandex.misc.bender.serialize.Marshaller;
import ru.yandex.misc.reflection.TypeX;

/**
 * @author dbrylev
 */
public class ChangeMarshallerUnmarshallerFactory implements CustomMarshallerUnmarshallerFactory {

    @Override
    public Option<Unmarshaller> createCustomUnmarshaller(
            BenderSettings settings, MainUnmarshallerFactory mainUnmarshallerFactory, TypeX type)
    {
        throw new NotImplementedException("unmarshalling is not implemented");
    }

    @Override
    public Option<Marshaller> createCustomMarshaller(
            BenderSettings settings, MainMarshallerFactory mainMarshallerFactory, TypeX type)
    {
        if (type.erasure().sameAs(Change.class)) {
            Marshaller valueMarshaller = mainMarshallerFactory.createMarshaller(type.getActualTypeArguments().single());
            return Option.of(new ChangeMarshaller(valueMarshaller));
        }
        return Option.empty();
    }
}
