package ru.yandex.calendar.frontend.bender;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.Bendable;

/**
 * @author dbrylev
 */
@Bendable
public class FilterablePojo<E> {
    private final E bendable;
    private final FilteringFields fields;

    private FilterablePojo(E bendable, FilteringFields fields) {
        this.bendable = bendable;
        this.fields = fields;
    }

    public static <E> FilterablePojo<E> wrap(E bendable, Option<FilteringFields> fields) {
        return new FilterablePojo<E>(bendable, fields.getOrElse(FilteringFields.anyFields()));
    }

    public static <E> FilterablePojo<E> wrap(E bendable, ListF<String> fields) {
        return new FilterablePojo<E>(bendable, FilteringFields.filtering(fields));
    }

    public E getBendable() {
        return bendable;
    }

    public FilteringFields getFields() {
        return fields;
    }
}
