package ru.yandex.calendar.frontend.bender;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryUtils;

/**
 * @author dbrylev
 */
public class FilterablePojoBenderConfiguration {

    private static class LazyBenderMapper implements Function0<BenderMapper> {
        private Option<BenderMapper> mapper = Option.empty();

        public void setConfiguration(BenderConfiguration configuration) {
            mapper = Option.of(new BenderMapper(configuration));
        }

        public BenderMapper apply() {
            return mapper.getOrThrow("Not configured");
        }
    }

    public static BenderConfiguration extend(BenderConfiguration configuration) {
        LazyBenderMapper mapperFactory = new LazyBenderMapper();

        configuration = new BenderConfiguration(
                configuration.getSettings(), CustomMarshallerUnmarshallerFactoryUtils.combine(
                        new FilterablePojoMarshallerUnmarshallerFactory(mapperFactory.memoize()),
                        configuration.getMarshallerUnmarshallerFactory()));

        mapperFactory.setConfiguration(configuration);
        return configuration;
    }
}
