package ru.yandex.calendar.frontend.bender;

import java.util.Map;

import org.apache.commons.lang.NotImplementedException;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function0;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.PartPosition;
import ru.yandex.misc.bender.internal.pojo.PojoDisassembler;
import ru.yandex.misc.bender.internal.pojo.PojoMarshaller;
import ru.yandex.misc.bender.internal.pojo.PojoMarshallingJsonCallback;
import ru.yandex.misc.bender.internal.pojo.PojoMarshallingXmlCallback;
import ru.yandex.misc.bender.internal.pojo.PojoPartId;
import ru.yandex.misc.bender.internal.pojo.PojoPartWithMarshallingGear;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.EmptyPojoMarshallingJsonCallback;
import ru.yandex.misc.bender.serialize.Marshaller;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshaller;
import ru.yandex.misc.bender.serialize.ToFieldMarshallerSupport;
import ru.yandex.misc.bender.serialize.ToFieldWithCallbackMarshaller;
import ru.yandex.misc.bender.serialize.ToParentObjectMarshaller;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.reflection.FieldX;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author dbrylev
 */
public class FilterablePojoMarshaller extends ToFieldMarshallerSupport implements ToFieldWithCallbackMarshaller {

    private final Function0<BenderMapper> mapperF;
    private final PojoMarshaller marshaller;

    private final PojoDisassembler disassembler;
    private final MapF<PojoPartId, PojoPartWithMarshallingGear> gearByPart;

    public FilterablePojoMarshaller(Function0<BenderMapper> mapperF, PojoMarshaller marshaller) {
        this.mapperF = mapperF;
        this.marshaller = marshaller;

        this.disassembler = getDisassembler();
        this.gearByPart = getGears();
    }

    @Override
    public void writeXmlToFieldWithCallback(
            XmlWriter writer, Object fieldValue,
            PojoMarshallingXmlCallback callback, MarshallerContext context)
    {
        throw new NotImplementedException("xml is not implemented");
    }

    @Override
    public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
        writeJsonToFieldWithCallback(writer, fieldValue, new EmptyPojoMarshallingJsonCallback(), context);
    }

    @Override
    public void writeJsonToFieldWithCallback(
            BenderJsonWriter writer, Object object,
            PojoMarshallingJsonCallback callback, MarshallerContext context)
    {
        if (object instanceof FilterablePojo) {
            FilterablePojo pojo = (FilterablePojo) object;
            mapper().serializeJson(pojo.getBendable(), writer,
                    new FilteringMarshallerContext(pojo.getFields(), context));

        } else if (context instanceof FilteringMarshallerContext && !((FilteringMarshallerContext) context).isAny()) {
            writeToFiledFiltered(writer, object, callback, (FilteringMarshallerContext) context);

        } else {
            marshaller.writeJsonToFieldWithCallback(writer, object, callback, context);
        }
    }

    private void writeToFiledFiltered(
            BenderJsonWriter json, Object object,
            PojoMarshallingJsonCallback callback, FilteringMarshallerContext context)
    {
        json.writeObjectStart();

        Tuple2List<PojoPartId, Object> parts = disassembler.disassemble(object);

        for (Tuple2<PojoPartId, Object> part: parts) {
            PojoPartWithMarshallingGear gear = gearByPart.getOrThrow(part.get1());
            Object value = part.get2();

            PartPosition.Ordinary gearPosition = (PartPosition.Ordinary) gear.getPosition();
            Marshaller gearMarshaller = gear.getMarshaller();

            if (gearMarshaller instanceof ToFieldMarshaller) {
                String name = gearPosition.getName().getLocalPartJson();
                FilteringMarshallerContext subContext = context.childrenContext(name);

                if (!subContext.isNothing()) {
                    json.writeFieldName(name);
                    ((ToFieldMarshaller) gearMarshaller).writeJsonToField(json, value, subContext);
                }
            } else {
                String name = gearPosition.getWrapperName().getOrElse(gearPosition.getName()).getLocalPartJson();
                FilteringMarshallerContext subContext = context.childrenContext(name);

                if (!subContext.isNothing()) {
                    ((ToParentObjectMarshaller) gearMarshaller)
                            .writeJsonToParentObject(json, value, gearPosition, subContext);
                }

            }
        }
        callback.writeJson(json);
        json.writeObjectEnd();
    }

    @SuppressWarnings("unchecked")
    private PojoDisassembler getDisassembler() {
        return (PojoDisassembler) ClassX.wrap(PojoMarshaller.class)
                .getDeclaredField("disassembler").<FieldX>setAccessibleTrueReturnThis().get(marshaller);
    }

    @SuppressWarnings("unchecked")
    private MapF<PojoPartId, PojoPartWithMarshallingGear> getGears() {
        MapF map = (MapF) ClassX.wrap(PojoMarshaller.class)
                .getDeclaredField("gearByPart").<FieldX>setAccessibleTrueReturnThis().get(marshaller);

        if (map.isNotEmpty()) {
            SetF<Map.Entry> entrySet = map.entrySet();
            Map.Entry entry = entrySet.iterator().next();
            Check.isTrue(entry.getKey() instanceof PojoPartId, "Unexpected key type ", entry.getKey().getClass());
            Check.isTrue(entry.getValue() instanceof PojoPartWithMarshallingGear, "Unexpected value type ", entry.getValue().getClass());
        }
        return map.uncheckedCast();
    }

    private BenderMapper mapper() {
        return mapperF.apply();
    }
}
