package ru.yandex.calendar.frontend.bender;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;
import ru.yandex.misc.ThreadLocalX;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.BenderUtils;
import ru.yandex.misc.bender.config.BenderSettings;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactory;
import ru.yandex.misc.bender.internal.pojo.PojoMarshaller;
import ru.yandex.misc.bender.parse.MainUnmarshallerFactory;
import ru.yandex.misc.bender.parse.Unmarshaller;
import ru.yandex.misc.bender.serialize.MainMarshallerFactory;
import ru.yandex.misc.bender.serialize.Marshaller;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.reflection.TypeX;

/**
 * @author dbrylev
 */
public class FilterablePojoMarshallerUnmarshallerFactory implements CustomMarshallerUnmarshallerFactory {

    private final ThreadLocalX<TypeX> customizing = new ThreadLocalX<TypeX>();
    private final Function0<BenderMapper> mapperF;


    public FilterablePojoMarshallerUnmarshallerFactory(Function0<BenderMapper> mapperF) {
        this.mapperF = mapperF;
    }

    @Override
    public Option<Unmarshaller> createCustomUnmarshaller(
            BenderSettings settings, MainUnmarshallerFactory mainUnmarshallerFactory, TypeX type)
    {
        return Option.empty();
    }

    @Override
    public Option<Marshaller> createCustomMarshaller(
            BenderSettings settings, MainMarshallerFactory mainMarshallerFactory, TypeX type)
    {
        if (customizing.getO().isPresent()) {
            Check.some(type, customizing.getO());

            customizing.remove();
            return Option.empty();
        }
        if (type.isClass() && BenderUtils.hasBendable(type.asClass())) {
            customizing.set(type);
            Marshaller original = mainMarshallerFactory.createMarshaller(type);

            return original instanceof PojoMarshaller
                    ? Option.<Marshaller>of(new FilterablePojoMarshaller(mapperF, (PojoMarshaller) original))
                    : Option.<Marshaller>empty();
        }
        return Option.empty();
    }
}
