package ru.yandex.calendar.frontend.bender;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author dbrylev
 */
public class FilteringFields {
    private final ListF<String> fields;
    private final boolean isAny;

    private FilteringFields(ListF<String> fields, boolean isAny) {
        this.fields = fields;
        this.isAny = isAny;
    }

    public boolean isNothing() {
        return !isAny() && fields.isEmpty();
    }

    public boolean isAny() {
        return isAny;
    }

    public FilteringFields getSubFields(String name) {
        if (isAny()) {
            return this;
        }
        Option<String> field = fields.find(Cf.String.equalsF(name));

        ListF<String> children = fields
                .filter(s -> s.startsWith(name + "/"))
                .map(s -> StringUtils.substring(s, name.length() + 1));

        return children.isEmpty() && field.isPresent()
                ? FilteringFields.anyFields()
                : FilteringFields.filtering(children);
    }

    public static FilteringFields filtering(ListF<String> fields) {
        return new FilteringFields(fields, false);
    }

    public static FilteringFields anyFields() {
        return new FilteringFields(Cf.<String>list(), true);
    }

    @Override
    public String toString() {
        return isAny ? "*" : fields.toString();
    }
}
