package ru.yandex.calendar.frontend.bender;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.parse.ReaderForParser;

/**
 * @author dbrylev
 */
public class FilteringFieldsParser {

    public static ListF<String> parseFields(String input) {
        return parseFields("", new Reader(input));
    }

    private static ListF<String> parseFields(String rootField, Reader reader) {
        ListF<String> result = Cf.arrayList();

        while (!reader.isEof() && !reader.nextIsBracket()) {
            String field = reader.nextUntilBracketOrComa();
            Validate.notEmpty(field, "expected name at pos " + reader.getPos());

            result.add(rootField + (rootField.isEmpty() ? "" : "/") + field);
            reader.consumeComaOptionalCheckNext();
        }

        if (reader.nextIsOpenBracket()) {
            reader.next();
            Validate.notEmpty(result, "expected name at pos " + reader.getPos());

            String field = result.remove(result.size() - 1);
            result.addAll(parseFields(field, reader));

            reader.consumeCloseBracket();
            reader.consumeComaOptionalCheckNext();
        }

        if (reader.nextIsCloseBracket()) {
            Validate.notEmpty(rootField, "unexpected ) at pos " + reader.getPos());
            Validate.notEmpty(result, "expected name at pos " + reader.getPos());

            return result;
        }
        if (!reader.isEof()) {
            result.addAll(parseFields(rootField, reader));
        }
        return result;
    }

    private static class Reader extends ReaderForParser {

        public Reader(String input) {
            super(input);
        }

        public boolean nextIsOpenBracket() {
            return nextIs('(');
        }

        public void consumeCloseBracket() {
            Validate.isTrue(nextIs(")"), "expected ) at pos " + getPos());
            advance();
        }

        public boolean nextIsCloseBracket() {
            return nextIs(')');
        }

        public boolean nextIsBracket() {
            return nextIsOpenBracket() || nextIsCloseBracket();
        }

        public void consumeComaOptionalCheckNext() {
            Validate.isTrue(!consumeOptional(',') || !nextIsBracket() && !isEof(), "expected name at pos " + getPos());
        }

        public String nextUntilBracketOrComa() {
            StringBuilder r = new StringBuilder();
            while (hasNext() && !nextIsAnyOf('(', ')', ',')) {
                r.append(next());
            }
            return r.toString();
        }

        public int getPos() {
            return pos;
        }
    }
}
