package ru.yandex.calendar.frontend.bender;

import ru.yandex.misc.bender.serialize.MarshallerContext;

/**
 * @author dbrylev
 */
public class FilteringMarshallerContext implements MarshallerContext {

    private final FilteringFields fields;
    private final MarshallerContext origContext;

    public FilteringMarshallerContext(FilteringFields fields, MarshallerContext origContext) {
        this.fields = fields;
        this.origContext = origContext;
    }

    public FilteringMarshallerContext childrenContext(String field) {
        return new FilteringMarshallerContext(fields.getSubFields(field), origContext);
    }

    public boolean isAny() {
        return fields.isAny();
    }

    public boolean isNothing() {
        return fields.isNothing();
    }

    public static MarshallerContext unwrap(MarshallerContext context) {
        return context instanceof FilteringMarshallerContext
                ? ((FilteringMarshallerContext) context).origContext
                : context;
    }
}
