package ru.yandex.calendar.frontend.bender;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

import ru.yandex.commune.mail.MailAddress;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.bender.parse.simpleType.SimpleTypeUnmarshallerSupport;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
public class MailAddressUnmarshaller extends SimpleTypeUnmarshallerSupport {
    @Override
    protected Object convert(String o) {
        try {
            InternetAddress address = new InternetAddress(o);
            return new MailAddress(new Email(address.getAddress()), address.getPersonal());

        } catch (AddressException e) {
            throw ExceptionUtils.translate(e);
        }
    }
}
