package ru.yandex.calendar.frontend.bender;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Types;

import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import lombok.ToString;
import org.springframework.jdbc.support.SqlValue;

import ru.yandex.commune.bazinga.pg.storage.dao.support.JsonSqlValue;

@RequiredArgsConstructor
@ToString(exclude = "parsed")
@EqualsAndHashCode(exclude = "parsed")
public class RawJson implements SqlValue {
    private static final ObjectReader parser = new ObjectMapper().readerFor(ObjectNode.class);

    @Getter
    private final String value;
    @Nullable
    private ObjectNode parsed;

    @Override
    public void setValue(PreparedStatement ps, int paramIndex) throws SQLException {
        ps.setObject(paramIndex, JsonSqlValue.escapeJson(value), Types.OTHER);
    }

    @Override
    public void cleanup() {
    }

    @SneakyThrows
    public ObjectNode getParsed() {
        if (parsed == null) {
            parsed = parser.readValue(value);
        }
        return parsed;
    }
}
