package ru.yandex.calendar.frontend.bender;

import lombok.val;

import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshallerSupport;
import ru.yandex.misc.xml.stream.XmlWriter;

public class RawJsonMarshaller extends ToFieldMarshallerSupport {
    @Override
    public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
        val rawJson = (RawJson) fieldValue;
        writer.writeRawValue(rawJson.getValue());
    }

    @Override
    public void writeXmlToField(XmlWriter writer, Object fieldValue, MarshallerContext context) {
        val rawJson = (RawJson) fieldValue;
        writer.textElement("data", rawJson.getValue());
    }
}
