package ru.yandex.calendar.frontend.bender;

import lombok.val;
import org.w3c.dom.Node;

import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.FieldLevelUnmarshaller;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.bender.parse.UnmarshallerContext;

public class RawJsonUnmarshaller implements FieldLevelUnmarshaller {
    @Override
    public ParseResult<Object> parseXmlNode(Node node, UnmarshallerContext context) {
        val rawJson = new RawJson(node.getTextContent());
        return ParseResult.result(rawJson);
    }

    @Override
    public ParseResult<Object> parseJsonNode(BenderJsonNode node, UnmarshallerContext context) {
        if (!node.isObject()) {
            return ParseResult.failure("Invalid json");
        }

        val rawJson = new RawJson(node.toString());
        return ParseResult.result(rawJson);
    }
}
