package ru.yandex.calendar.frontend.bender;

import java.sql.ResultSet;

import lombok.val;

import ru.yandex.commune.mapObject.db.type.DatabaseValueType;
import ru.yandex.misc.db.resultSet.ResultSetUtils;

import static java.util.Objects.requireNonNullElse;

public class RawJsonValueType extends DatabaseValueType<RawJson> {
    private static RawJson extract(ResultSet resultSet, ResultSetUtils.ResultSetColumnAddress address) {
        val value = ResultSetUtils.getF(String.class).apply(resultSet, address);
        return new RawJson(requireNonNullElse(value, "{}"));
    }

    public RawJsonValueType() {
        super(RawJson.class, RawJsonValueType::extract);
    }
}
