package ru.yandex.calendar.frontend.bender;

import ru.yandex.calendar.util.email.Emails;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshaller;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author dbrylev
 */
public class UnicodeEmailMarshaller implements ToFieldMarshaller {

    @Override
    public void writeXmlToField(XmlWriter writer, Object fieldValue, MarshallerContext context) {
        writer.addCharacters(Emails.getUnicoded((Email) fieldValue));
    }

    @Override
    public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
        writer.writeString(Emails.getUnicoded((Email) fieldValue));
    }

    @Override
    public String getXmlFieldTextValue(Object fieldValue, MarshallerContext context) {
        return Emails.getUnicoded((Email) fieldValue);
    }

    @Override
    public String getJsonFieldTextValue(Object fieldValue, MarshallerContext context) {
        return Emails.getUnicoded((Email) fieldValue);
    }
}
