package ru.yandex.calendar.frontend.bender;

import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Either;

/**
 * @author dbrylev
 */
public class WebDate {
    private Either<LocalDate, WebDateTime> date;

    private WebDate(Either<LocalDate, WebDateTime> date) {
        this.date = date;
    }

    public static WebDate localDate(LocalDate date) {
        return new WebDate(Either.left(date));
    }

    public static WebDate dateTime(WebDateTime dateTime) {
        return new WebDate(Either.right(dateTime));
    }

    public Instant toInstant(DateTimeZone tz) {
        return toInstant(false, tz);
    }

    public Instant toInstantNextDay(DateTimeZone tz) {
        return toInstant(true, tz);
    }

    private Instant toInstant(boolean nextDay, DateTimeZone tz) {
        return date.fold(
                dt -> dt.plusDays(nextDay ? 1 : 0).toDateTimeAtStartOfDay(tz).toInstant(), dt -> dt.toInstant(tz));
    }

    @Override
    public String toString() {
        return date.fold(Object::toString, Object::toString);
    }
}
