package ru.yandex.calendar.frontend.bender;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.LocalDateTime;
import org.joda.time.base.AbstractInstant;

import ru.yandex.bolts.collection.Either;
import ru.yandex.calendar.util.dates.AuxDateTime;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author dbrylev
 */
public class WebDateTime extends DefaultObject {
    private final Either<LocalDateTime, DateTime> dateTime;

    private WebDateTime(Either<LocalDateTime, DateTime> dateTime) {
        this.dateTime = dateTime;
    }

    public static WebDateTime localDateTime(LocalDateTime dateTime) {
        return new WebDateTime(Either.left(dateTime));
    }

    public static WebDateTime dateTime(DateTime dateTime) {
        return new WebDateTime(Either.right(dateTime));
    }

    public boolean isLocal() {
        return dateTime.isLeft();
    }

    public LocalDateTime getLocalDateTime() {
        return dateTime.getLeft();
    }

    public DateTime getDateTime() {
        return dateTime.getRight();
    }

    public LocalDateTime getDateTimeUtc() {
        return getDateTime().toDateTime(DateTimeZone.UTC).toLocalDateTime();
    }

    public LocalDateTime toLocalDateTime() {
        return dateTime.fold(dt -> dt, DateTime::toLocalDateTime);
    }

    public Instant toInstant(DateTimeZone tz) {
        return dateTime.fold(dt -> AuxDateTime.toInstantIgnoreGap(dt, tz), AbstractInstant::toInstant);
    }

    @Override
    public String toString() {
        return dateTime.fold(Object::toString, Object::toString);
    }
}
