package ru.yandex.calendar.frontend.bender;

import org.apache.commons.lang.NotImplementedException;

import ru.yandex.misc.bender.parse.simpleType.SimpleTypeUnmarshallerSupport;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshaller;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author dbrylev
 */
public class WebDateTimeMarshallerUnmarshaller extends SimpleTypeUnmarshallerSupport implements ToFieldMarshaller {

    @Override
    protected Object convert(String o) {
        return WebDateUtils.parseDateTime(o);
    }

    @Override
    public void writeXmlToField(XmlWriter writer, Object fieldValue, MarshallerContext context) {
        throw new NotImplementedException();
    }

    @Override
    public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
        WebDateTime dt = (WebDateTime) fieldValue;

        context = FilteringMarshallerContext.unwrap(context);

        if (context instanceof WebDateFormatMarshallerContext && ((WebDateFormatMarshallerContext) context).isZoned()) {
            writer.writeString(dt.isLocal()
                    ? WebDateUtils.serialize(dt.getLocalDateTime())
                    : WebDateUtils.serialize(dt.getDateTime()));
        } else {
            writer.writeString(WebDateUtils.serialize(dt.toLocalDateTime()));
        }
    }

    @Override
    public String getXmlFieldTextValue(Object fieldValue, MarshallerContext context) {
        throw new NotImplementedException();
    }

    @Override
    public String getJsonFieldTextValue(Object fieldValue, MarshallerContext context) {
        throw new NotImplementedException();
    }
}
