package ru.yandex.calendar.frontend.bender;

import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.parameter.WebRequest;

/**
 * @author dbrylev
 */
public class WebDateUtils {
    private static final DateTimeFormatter LOCAL_DATE_TIME_FORMATTER =
            DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss");
    private static final DateTimeFormatter DATE_TIME_FORMATTER =
            ISODateTimeFormat.dateTimeNoMillis().withOffsetParsed();
    private static final DateTimeFormatter DATE_FORMATTER =
            DateTimeFormat.forPattern("yyyy-MM-dd");

    public static WebDateTime parseDateTime(String value) {
        try {
            return WebDateTime.dateTime(DATE_TIME_FORMATTER.parseDateTime(value));
        } catch (IllegalArgumentException e) {
            return WebDateTime.localDateTime(LOCAL_DATE_TIME_FORMATTER.parseLocalDateTime(value));
        }
    }

    public static WebDate parseDate(String value) {
        try {
            return WebDate.dateTime(parseDateTime(value));
        } catch (IllegalArgumentException e) {
            return WebDate.localDate(DATE_FORMATTER.parseLocalDate(value));
        }
    }

    public static String serialize(LocalDate date) {
        return DATE_FORMATTER.print(date);
    }

    public static String serialize(LocalDateTime localDateTime) {
        return LOCAL_DATE_TIME_FORMATTER.print(localDateTime);
    }

    public static String serialize(DateTime dateTime) {
        return DATE_TIME_FORMATTER.print(dateTime);
    }

    private static final String DATE_FORMAT_PARAMETER = "dateFormat";

    public static WebDateFormatMarshallerContext marshallerContext(WebRequest request) {
        Option<String> format = request.getParameter(DATE_FORMAT_PARAMETER).singleO();

        return new WebDateFormatMarshallerContext(format.isSome("zoned"));
    }
}
