package ru.yandex.calendar.frontend.caldav;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.calendar.admin.CalendarPingServlet;
import ru.yandex.calendar.frontend.caldav.impl.CaldavInitializer;
import ru.yandex.calendar.frontend.caldav.impl.CaldavJackrabbitServlet;
import ru.yandex.calendar.frontend.caldav.impl.CaldavService;
import ru.yandex.calendar.frontend.caldav.impl.CaldavServiceImpl;
import ru.yandex.calendar.frontend.caldav.proto.CaldavLocatorFactory;
import ru.yandex.calendar.frontend.caldav.proto.facade.CaldavCalendarEventsPlusTodosProvider;
import ru.yandex.calendar.frontend.caldav.proto.facade.CaldavCalendarEventsProvider;
import ru.yandex.calendar.frontend.caldav.proto.facade.CaldavCalendarFacade;
import ru.yandex.calendar.frontend.caldav.proto.facade.CaldavCalendarFacadeImpl;
import ru.yandex.calendar.frontend.caldav.proto.facade.CaldavCalendarFacadeProvider;
import ru.yandex.calendar.frontend.caldav.proto.facade.CaldavCalendarTodosProvider;
import ru.yandex.calendar.frontend.caldav.proto.facade.CarddavCalendarFacade;
import ru.yandex.calendar.frontend.caldav.proto.facade.CarddavCalendarFacadeImpl;
import ru.yandex.calendar.frontend.caldav.proto.facade.CcCalendarFacade;
import ru.yandex.calendar.frontend.caldav.proto.facade.CcCalendarFacadeImpl;
import ru.yandex.calendar.frontend.caldav.proto.facade.CcManager;
import ru.yandex.calendar.frontend.caldav.proto.tree.CaldavContext;
import ru.yandex.calendar.frontend.caldav.proto.tree.CaldavResourceFactory;
import ru.yandex.calendar.logic.log.requests.RequestContentCachingFilter;
import ru.yandex.calendar.logic.log.requests.RequestLoggingContextConfiguration;
import ru.yandex.calendar.unistat.ApiUnistatContextConfiguration;
import ru.yandex.calendar.util.JettyConfiguration;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

@Configuration
@Import({
        ApiUnistatContextConfiguration.class,
        RequestLoggingContextConfiguration.class,
})
public class CaldavContextConfiguration {
    @Bean
    public SingleWarJetty caldavJetty(RequestContentCachingFilter cachingFilter) {
        SingleWarJetty jetty = JettyConfiguration.fromProperties("caldav").consJetty();

        // nginx is useless since it does not gzip 207 status responses
        jetty.setUseGzip(true);
        jetty.setGzipMimeTypes(Cf.set("text/calendar", "text/x-vcard", "text/xml"));

        jetty.addServletMapping("/ping/*", pingConfigurableServlet());
        jetty.addServletMapping("/*", caldavJackrabbitServlet());
        jetty.addFilterMapping("/*", cachingFilter);

        return jetty;
    }

    @Bean
    public CaldavJackrabbitServlet caldavJackrabbitServlet() {
        try {
            return new CaldavJackrabbitServlet();
        } catch (Exception e) {
            throw ExceptionUtils.throwException(e);
        }
    }

    @Bean
    public CaldavService caldavService() {
        return new CaldavServiceImpl();
    }

    @Bean
    public CaldavInitializer caldavInitializer() {
        return new CaldavInitializer();
    }

    @Bean
    public CaldavResourceFactory caldavResourceFactory() {
        return new CaldavResourceFactory();
    }

    @Bean
    public CaldavLocatorFactory caldavLocatorFactory() {
        return new CaldavLocatorFactory();
    }

    @Bean
    public CaldavCalendarFacade caldavCalendarFacade() {
        return new CaldavCalendarFacadeImpl();
    }

    @Bean
    public CaldavCalendarFacadeProvider caldavCalendarEventsProvider() {
        return new CaldavCalendarEventsProvider();
    }

    @Bean
    public CaldavCalendarFacadeProvider caldavCalendarTodosProvider() {
        return new CaldavCalendarTodosProvider();
    }

    @Bean
    public CaldavCalendarFacadeProvider caldavCalendarEventsPlusTodosProvider() {
        return new CaldavCalendarEventsPlusTodosProvider();
    }

    @Bean
    public CaldavContext caldavContext() {
        return new CaldavContext();
    }

    @Bean
    public CarddavCalendarFacade carddavCalendarFacade() {
        return new CarddavCalendarFacadeImpl();
    }

    @Bean
    public CcCalendarFacade ccCalendarFacade() {
        return new CcCalendarFacadeImpl();
    }

    @Bean
    public CcManager ccManager() {
        return new CcManager();
    }

    @Bean
    public CalendarPingServlet pingConfigurableServlet() {
        return new CalendarPingServlet();
    }
}
