package ru.yandex.calendar.frontend.caldav;

import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;

import ru.yandex.calendar.frontend.caldav.proto.tree.PropertiesCollection;
import ru.yandex.misc.lang.Check;

/**
 * @author Stepan Koltsov
 */
public class WebdavUtils {

    public static DavPropertySet getPropertiesFromNames(PropertiesCollection thiz) {
        DavPropertySet ps = new DavPropertySet();
        for (DavPropertyName name : thiz.getPropertyNames()) {
            // XXX: not sure calendardata should be included here
            DavProperty<?> property = thiz.getProperty(name);
            Check.C.notNull(property, "property not found by name " + name);
            ps.add(property);
        }
        return ps;
    }

} //~
