package ru.yandex.calendar.frontend.caldav.impl;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.logic.domain.PassportAuthDomainsHolder;
import ru.yandex.misc.web.servlet.WtdFilter;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author Stepan Koltsov
 */
public class CaldavInitializer {

    @Autowired
    private SingleWarJetty caldavJetty;

    @Autowired
    private PassportAuthDomainsHolder passportAuthDomainsHolder;

    @PostConstruct
    public void init() {
        caldavJetty.addFilterMapping("/*", new WtdFilter());
        boolean printDebugInfo = passportAuthDomainsHolder.containsYandexTeamRu();
        caldavJetty.addFilterMapping("/*", new CaldavFilter(printDebugInfo));
    }

} //~
