package ru.yandex.calendar.frontend.caldav.impl;

import lombok.experimental.UtilityClass;
import org.joda.time.Instant;

import ru.yandex.calendar.frontend.caldav.proto.ETag;

@UtilityClass
public class EventEtag {
    public ETag lastModifiedToEtag(Instant lastModified) {
        return new ETag(Long.toString(lastModified.getMillis()));
    }

    public Instant lastModifiedFromETag(ETag eTag) {
        return new Instant(getMillisFromEtag(eTag));
    }

    public long getMillisFromEtag(ETag etag) {
        return Long.parseLong(getValue(etag));
    }

    private String getValue(ETag eTag) {
        return eTag.unquoted().getValue();
    }
}
