package ru.yandex.calendar.frontend.caldav.impl;

import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.misc.codec.FastBase64Coder;
import ru.yandex.misc.lang.Validate;

/**
 * @author Stepan Koltsov
 */
public class HttpBasicAuthentication {

    public static final String BASIC_PREFIX = "Basic ";

    public static Tuple2<String, String> parseBasic(String value) {
        Validate.isTrue(value.startsWith(BASIC_PREFIX));
        String encoded = value.substring(BASIC_PREFIX.length());
        String pairString = FastBase64Coder.decodeToString(encoded);
        String[] pair = pairString.split(":", 2);
        String login = pair[0];
        String password = pair[1];
        return Tuple2.tuple(login, password);
    }

} //~
