package ru.yandex.calendar.frontend.caldav.impl;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

/**
 * @author Sergey Shinderuk
 */
public class JackrabbitHacks {

    private JackrabbitHacks() { }

    /**
     * Prevent XXE and related attacks in CalDAV (CAL-5902)
     *
     * @url https://www.owasp.org/index.php/XML_External_Entity_%28XXE%29_Processing
     * @url http://en.wikipedia.org/wiki/Billion_laughs
     */
    public static void configureXmlParserForSecurity() {
        try {
            DocumentBuilderFactory factory = org.apache.jackrabbit.webdav.xml.DomUtil.BUILDER_FACTORY;
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setFeature("http://apache.org/xml/features/validation/schema", false);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        } catch (ParserConfigurationException e) {
            throw new Error(e);
        }
    }

}
