package ru.yandex.calendar.frontend.caldav.impl;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.caldav.proto.CTag;
import ru.yandex.calendar.logic.beans.generated.Layer;

/**
 * @author gutman
 */
public class LayerCtag {

    public static CTag layerCollLastUpdateToCTag(Layer layer) {
        return new CTag(Long.toString(layer.getCollLastUpdateTs().getMillis()));
    }

    public static CTag lastUpdateTsToCTag(Option<Instant> instant) {
        return new CTag(Long.toString(instant.map(Instant::getMillis).getOrElse(0L)));
    }

    public static CTag lastUpdateTsToCTag(Instant instant) {
        return lastUpdateTsToCTag(Option.of(instant));
    }

}
