package ru.yandex.calendar.frontend.caldav.impl;

import ru.yandex.calendar.frontend.caldav.proto.tree.CalendarUrls;
import ru.yandex.inside.passport.blackbox.PassportAuthDomain;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.net.HostnameUtils;

/**
 * @author Stepan Koltsov
 *
 * @see CalendarUrls
 */
public class YandexCaldavUrls {

    private static String caldavHostname(EnvironmentType environmentType, PassportAuthDomain authDomain) {
        if (environmentType == EnvironmentType.PRODUCTION) {
            return "caldav." + authDomain.getDomain();
        } else if (environmentType == EnvironmentType.TESTING) {
            return "caldav.tst." + authDomain.getDomain();
        } else {
            return "caldav." + HostnameUtils.localHostname();
        }
    }

    public static String userUrl(Email email, EnvironmentType environmentType) {
        return "https://" + caldavHostname(environmentType, PassportAuthDomain.byEmail(email)) + CalendarUrls.user(email.getEmail()).getEncoded();
    }

    public static String calendarUrl(Email email, long layerId, EnvironmentType environmentType) {
        return "https://" + caldavHostname(environmentType, PassportAuthDomain.byEmail(email)) + CalendarUrls.events(email.getEmail(), String.valueOf(layerId)).getEncoded();
    }

} //~
