package ru.yandex.calendar.frontend.caldav.proto;

import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.caldav.proto.facade.CaldavCalendarFacade;
import ru.yandex.calendar.frontend.caldav.proto.tree.CaldavResourceLocator;

/**
 * @author Stepan Koltsov
 */
public class CaldavLocatorFactory implements DavLocatorFactory {

    @Autowired
    private CaldavCalendarFacade caldavCalendarFacade;

    @Override
    public DavResourceLocator createResourceLocator(String prefix, String href) {
        return new CaldavResourceLocator(caldavCalendarFacade, href);
    }

    @Override
    public DavResourceLocator createResourceLocator(String prefix, String workspacePath, String resourcePath) {
        throw new UnsupportedOperationException();
        //return new CaldavResourceLocator();
    }

    @Override
    public DavResourceLocator createResourceLocator(String prefix, String workspacePath, String path, boolean isResourcePath) {
        throw new UnsupportedOperationException();
        //return new CaldavResourceLocator();
    }

} //~
