package ru.yandex.calendar.frontend.caldav.proto;

import lombok.extern.slf4j.Slf4j;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavMethods;
import org.apache.jackrabbit.webdav.DavSessionProvider;
import org.apache.jackrabbit.webdav.WebdavRequest;

/**
 * @author Stepan Koltsov
 */
@Slf4j
public class CaldavSessionProvider implements DavSessionProvider {
    //private static final org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(CaldavSessionProvider.class);

    @Override
    public boolean attachSession(WebdavRequest request) throws DavException {
        int methodCode = DavMethods.getMethodCode(request.getMethod());
        if (methodCode == 0) {
            log.debug("attachSession for method: " + request.getMethod() + ", methodCode: " + methodCode );
        }
        return true;
    }

    @Override
    public void releaseSession(WebdavRequest request) {
    }

} //~
