package ru.yandex.calendar.frontend.caldav.proto;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.caldav.proto.facade.CcClientScope;
import ru.yandex.calendar.frontend.caldav.proto.facade.CcUserInfo;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author Stepan Koltsov
 */
public class ClientHolder {

    public static final ThreadLocal<CcUserInfo> holder = new ThreadLocal<>();

    // XXX: return resolved value
    public static String get() {
        return Option.ofNullable(holder.get()).get().getEmail().getEmail();
    }

    public static PassportUid getPassportUid() {
        return Option.ofNullable(holder.get()).get().getUid();
    }

    public static CcUserInfo getCcUserInfo() {
        return Option.ofNullable(holder.get()).get();
    }

    public static String getSafe() {
        return Option.ofNullable(holder.get()).map(ccUserInfo -> ccUserInfo.getEmail().getEmail()).getOrElse("?");
    }

    public static CcClientScope getScope() {
        return Option.ofNullable(holder.get()).get().getScope();
    }
}
