package ru.yandex.calendar.frontend.caldav.proto;

import ru.yandex.misc.lang.Validate;

abstract class ETagOrCTag {

    private final String value;

    ETagOrCTag(String value) {
        Validate.notEmpty(value); // XXX: better validation
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return value;
    }

    @Override
    public boolean equals(Object o) {
        return o != null && getClass() == o.getClass()
                && ((ETagOrCTag) o).value.equals(this.value);
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }
}
