package ru.yandex.calendar.frontend.caldav.proto;

import lombok.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.Validate;

@Value
public final class PutResponse {
    int statusCode;
    Option<ETag> etag;
    Option<String> description;

    public PutResponse(int statusCode, String etag, String description) {
        this(statusCode, Option.ofNullable(etag).map(ETag.consF()), Option.ofNullable(description));
    }

    public PutResponse(int statusCode, Option<ETag> etag, Option<String> description) {
        Validate.ge(statusCode, 0);
        this.statusCode = statusCode;
        this.etag = etag;
        this.description = description;
    }
}
