package ru.yandex.calendar.frontend.caldav.proto.caldav;

import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.ResourceType;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.dom4j.QName;

import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.misc.xml.dom4j.Dom4jUtils;

/**
 * @see DavConstants
 * @see WebdavConstants
 */
public class CaldavConstants {

    public static final String CALDAV_NS_URI         = "urn:ietf:params:xml:ns:caldav";
    public static final String ICAL_NS_URI           = "http://apple.com/ns/ical/";
    public static final String CALENDARSERVER_NS_URI = "http://calendarserver.org/ns/";

    public static final Namespace CALDAV_NS         = Namespace.getNamespace("C", CALDAV_NS_URI);
    public static final Namespace ICAL_NS           = Namespace.getNamespace(ICAL_NS_URI);
    public static final Namespace CALENDARSERVER_NS = Namespace.getNamespace(CALENDARSERVER_NS_URI);

    public static final DavPropertyName CALDAV_USER_ADDRESS_SET_PROP =                 DavPropertyName.create("calendar-user-address-set", CALDAV_NS);
    public static final DavPropertyName CALDAV_HOME_SET_PROP =                         DavPropertyName.create("calendar-home-set", CALDAV_NS);
    public static final DavPropertyName CALDAV_TIMEZONE_PROP =                         DavPropertyName.create("calendar-timezone", CALDAV_NS);
    public static final DavPropertyName CALDAV_CALENDAR_DATA_PROP =                    DavPropertyName.create("calendar-data", CALDAV_NS);
    /** @url http://tools.ietf.org/html/draft-desruisseaux-caldav-sched-08#section-13.2 */
    public static final DavPropertyName CALDAV_SCHEDULE_OUTBOX_URL_PROP =              DavPropertyName.create("schedule-outbox-URL", CALDAV_NS);
    public static final DavPropertyName CALDAV_SCHEDULE_INBOX_URL_PROP =               DavPropertyName.create("schedule-inbox-URL", CALDAV_NS);
    public static final DavPropertyName CALDAV_SCHEDULE_CALENDAR_TRANSP =              DavPropertyName.create("schedule-calendar-transp", CALDAV_NS);
    /** @url http://tools.ietf.org/html/draft-desruisseaux-caldav-sched-09#section-12.2 */
    public static final DavPropertyName CALDAV_SCHEDULE_DEFAULT_CALENDAR_URL_PROP =    DavPropertyName.create("schedule-default-calendar-URL", CALDAV_NS);
    public static final DavPropertyName CALDAV_CALENDAR_USER_TYPE_PROP =               DavPropertyName.create("calendar-user-type", CALDAV_NS);
    public static final DavPropertyName CALDAV_CALENDAR_USER_ADDRESS_SET_PROP =        DavPropertyName.create("calendar-user-address-set", CALDAV_NS);
    public static final DavPropertyName CALDAV_SUPPORTED_CALENDAR_COMPONENT_SET_PROP = DavPropertyName.create("supported-calendar-component-set", CALDAV_NS);
    public static final DavPropertyName CALDAV_SUPPORTED_CALENDAR_COMPONENT_SETS_PROP = DavPropertyName.create("supported-calendar-component-sets", CALDAV_NS);

    public static final DavPropertyName CALENDAR_COLOR_PROP = DavPropertyName.create("calendar-color", ICAL_NS);
    public static final DavPropertyName CALENDAR_ORDER_PROP = DavPropertyName.create("calendar-order", ICAL_NS);

    public static final DavPropertyName CALENDARSERVER_RECORD_TYPE_PROP =              DavPropertyName.create("record-type",              CALENDARSERVER_NS);
    public static final DavPropertyName CALENDARSERVER_CALENDAR_PROXY_WRITE_FOR_PROP = DavPropertyName.create("calendar-proxy-write-for", CALENDARSERVER_NS);
    public static final DavPropertyName CALENDARSERVER_CALENDAR_PROXY_READ_FOR_PROP =  DavPropertyName.create("calendar-proxy-read-for",  CALENDARSERVER_NS);
    public static final DavPropertyName CALENDARSERVER_GETCTAG_PROP =                  DavPropertyName.create("getctag",                  CALENDARSERVER_NS);
    public static final DavPropertyName CALENDARSERVER_EMAIL_ADDRESS_SET_PROP =        DavPropertyName.create("email-address-set",        CALENDARSERVER_NS);
    public static final DavPropertyName CALENDARSERVER_LAST_NAME_PROP =                DavPropertyName.create("last-name",                CALENDARSERVER_NS);
    public static final DavPropertyName CALENDARSERVER_FIRST_NAME_PROP =               DavPropertyName.create("first-name",               CALENDARSERVER_NS);

    private static int registerResourceType(String name) {
        return ResourceType.registerResourceType(name, CALDAV_NS);
    }

    public static final int CALDAV_CALENDAR_RT =        registerResourceType("calendar");
    public static final int CALDAV_SCHEDULE_INBOX_RT =  registerResourceType("schedule-inbox");
    public static final int CALDAV_SCHEDULE_OUTBOX_RT = registerResourceType("schedule-outbox");

    private static QName createQName(String name) {
        return Dom4jUtils.createQName(name, CALDAV_NS.getPrefix(), CALDAV_NS.getURI());
    }

    public static final QName CALDAV_SCHEDULE_RESPONSE_QNAME =   createQName("schedule-response");
    public static final QName CALDAV_RESPONSE_QNAME =            createQName("response");
    public static final QName CALDAV_RECEPIENT_QNAME =           createQName("recipient");
    public static final QName CALDAV_REQUEST_STATUS_QNAME =      createQName("request-status");
    public static final QName CALDAV_RESPONSEDESCRIPTION_QNAME = createQName("responsedescription");
    public static final QName CALDAV_CALENDAR_DATA_QNAME =       createQName("calendar-data");
    public static final QName CALDAV_CALENDAR_QUERY_QNAME =      createQName("calendar-query");
    public static final QName CALDAV_CALENDAR_MULTIGET_QNAME =   createQName("calendar-multiget");
    public static final QName CALDAV_FREE_BUSY_QUERY_QNAME =     createQName("free-busy-query");
    public static final QName CALDAV_FILTER_QNAME =              createQName("filter");
    public static final QName CALDAV_TIMEZONE_QNAME =            createQName("timezone");
    public static final QName CALDAV_COMP_FILTER_QNAME =         createQName("comp-filter");
    public static final QName CALDAV_PROP_FILTER_QNAME =         createQName("prop-filter");
    public static final QName CALDAV_TEXT_MATCH_QNAME =          createQName("text-match");
    public static final QName CALDAV_IS_NOT_DEFINED_QNAME =      createQName("is-not-defined");
    public static final QName CALDAV_TIME_RANGE_QNAME =          createQName("time-range");
    public static final QName CALDAV_COMP_QNAME =                createQName("comp");

    /**
     * @url http://svn.calendarserver.org/repository/calendarserver/CalendarServer/trunk/doc/Extensions/caldav-proxy.txt (?)
     */
    public static final String CALENDAR_PROXY_DAV = "calendar-proxy";
    /**
     * @url http://tools.ietf.org/html/draft-desruisseaux-caldav-sched-04 and not in next
     * @see #CALENDAR_AUTO_SCHEDULE_DAV
     */
    public static final String CALENDAR_SCHEDULE_DAV = "calendar-schedule";
    /**
     * http://tools.ietf.org/html/draft-desruisseaux-caldav-sched-09
     * @see #CALENDAR_SCHEDULE_DAV
     */
    public static final String CALENDAR_AUTO_SCHEDULE_DAV = "calendar-auto-schedule";
    /**
     * @url http://tools.ietf.org/html/rfc4791
     */
    public static final String CALENDAR_ACCESS_DAV = "calendar-access";
    /**
     * http://tools.ietf.org/html/draft-daboo-calendar-availability-01
     */
    public static final String CALENDAR_AVAILABILITY_DAV = "calendar-availability";
    /**
     * Spec?
     */
    public static final String INBOX_AVAILABILITY_DAV = "inbox-availability";
    /**
     * @url http://svn.calendarserver.org/repository/calendarserver/CalendarServer/trunk/doc/Extensions/caldav-privateevents.txt
     */
    public static final String CALENDARSERVER_PRIVATE_EVENTS_DAV = "calendarserver-private-events";
    /**
     * @url http://svn.calendarserver.org/repository/calendarserver/CalendarServer/trunk/doc/Extensions/caldav-privatecomments.txt
     */
    public static final String CALENDARSERVER_PRIVATE_COMMENTS_DAV = "calendarserver-private-comments";
    /**
     * @url http://svn.calendarserver.org/repository/calendarserver/CalendarServer/trunk/doc/Extensions/caldav-sharing-02.txt
     */
    public static final String CALENDARSERVER_SHARING_DAV = "calendarserver-sharing";
    /**
     * Spec?
     */
    public static final String CALENDARSERVER_SHARING_NO_SCHEDULING_DAV = "calendarserver-sharing-no-scheduling";
    /**
     * Spec?
     */
    public static final String CALENDARSERVER_PRINCIPAL_PROPERTY_SEARCH_DAV = "calendarserver-principal-property-search";

} //~
