package ru.yandex.calendar.frontend.caldav.proto.caldav;

import java.util.Set;

import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.xml.dom.DomUtils;


/**
 * @author Stepan Koltsov
 */
public class CaldavSupportedCalendarComponentSet extends AbstractDavProperty<Set<XmlSerializable>> {
    private final String[] componentNames;

    public CaldavSupportedCalendarComponentSet(String[] componentNames) {
        super(CaldavConstants.CALDAV_SUPPORTED_CALENDAR_COMPONENT_SET_PROP, false);
        this.componentNames = componentNames;
    }

    public ListF<String> getComponentNames() {
        return Cf.x(componentNames);
    }

    @Override
    public Set<XmlSerializable> getValue() {
        Set<XmlSerializable> components = Cf.hashSet();
        for (final String componentName : componentNames) {
            components.add(new XmlSerializable() {
                public Element toXml(Document document) {
                    Element comp = document.createElementNS(CaldavConstants.CALDAV_COMP_QNAME.getNamespaceURI(),
                            CaldavConstants.CALDAV_COMP_QNAME.getNamespacePrefix() + ":" + CaldavConstants.CALDAV_COMP_QNAME.getName());
                    comp.setAttribute("name", componentName);
                    return comp;
                }
            });
        }
        return components;
    }

    public static CaldavSupportedCalendarComponentSet createFromXml(Element element) {
        Validate.isTrue(DomUtil.matches(element,
                CaldavConstants.CALDAV_SUPPORTED_CALENDAR_COMPONENT_SET_PROP.getName(),
                CaldavConstants.CALDAV_SUPPORTED_CALENDAR_COMPONENT_SET_PROP.getNamespace()));

        ListF<String> componentNames = Cf.arrayList();
        for (Element comp : DomUtils.childElements(element)) {
            Validate.isTrue(DomUtil.matches(comp,
                    CaldavConstants.CALDAV_COMP_QNAME.getName(),
                    Namespace.getNamespace(CaldavConstants.CALDAV_COMP_QNAME.getNamespaceURI())));

            Option<String> componentName = DomUtils.getAttribute(comp, "name");
            Validate.some(componentName);
            componentNames.addAll(componentName);
        }
        return new CaldavSupportedCalendarComponentSet(componentNames.toArray(String.class));
    }

} //~
